<?php

namespace App\Http\Controllers\Core;


use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\student\CreatestudentRequest;
use App\Http\Requests\student\UpdatestudentRequest;
use App\Models\Level;
use App\Models\SubLevel;
use App\Models\User;
use App\Services\Model\StudentService;
use Illuminate\Http\Request;

class StudentController extends CoreController
{

    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct(
        protected StudentService $studentService
    ) {
        $this->model = $this->resolveModelName();
    }


    public function addLevel(Request $request, $id)
    {

        $level = Level::find($id);
        $subLevel = SubLevel::find($request->input('sub'));

        if ($level && $this->studentService->changeLevel($level, $subLevel)) {
            return $this->redirectWithNotification(back(), 'level added', 'success');
        }

        return $this->redirectWithNotification(back(), 'level not added', 'fail');
    }



    public function createOne(CreatestudentRequest $request)
    {
        if (
            $this->create($request, [])
        ) {

            if ($this->modelCreated) {

                $user = User::find($this->modelCreated->user_id);

                if ($user) {
                    $user->update([
                        'name' => $request->validated('name'),
                        'first_name' => $request->validated('first_name'),
                        'last_name' => $request->validated('last_name'),
                        // 'phone' => $request->validated('phone'),
                        'email' => $request->validated('email'),
                    ]);
                }
            }

            return $this->redirectWithNotification(
                redirect()->route('admin.students', ['id' => $request->material_id]),
                'success',
                'student created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create student');
    }

    public function updateOne(UpdateStudentRequest $request, $id)
    {
        if ($this->update($request, $id)) {

            $user = User::find($this->modelUpdated->user_id);

            if ($user) {
                $user->update([
                    'name' => $request->validated('name') ?? $user->name,
                    'first_name' => $request->validated('first_name') ?? $user->first_name,
                    'last_name' => $request->validated('last_name') ?? $user->last_name,
                    'email' => $request->validated('email') ?? $user->email,
                ]);
            }

            return $this->redirectWithNotification(
                redirect()->route('admin.students', ['id' => $request->material_id]),
                'success',
                'student updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update student');
    }

    public function updateStudentProfile(UpdateStudentRequest $request)
    {
        if ($this->update($request,$request->validated('id') )) {

            $user = User::find($this->modelUpdated->user_id);

            if ($user) {
                $user->update([
                    'name' => $request->validated('name') ?? $user->name,
                    'first_name' => $request->validated('first_name') ?? $user->first_name,
                    'last_name' => $request->validated('last_name') ?? $user->last_name,
                    'email' => $request->validated('email') ?? $user->email,
                ]);
            }

            return $this->redirectWithNotification(
                redirect()->route('admin.students', ['id' => $request->material_id]),
                'success',
                'student updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update student');
    }

    public function deleteOne($id)
    {
        if ($this->delete($id)) {
            return $this->redirectWithNotification(
                back(),
                'success',
                'student deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete student');
    }
}
