<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\SubLevel\CreateSubLevelRequest;
use App\Http\Requests\SubLevel\UpdateSubLevelRequest;
use Illuminate\Http\Request;

class SubLevelController extends CoreController
{
    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct() {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateSubLevelRequest $request)
    {
        if($this->create($request)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.levels'), 'success', 'SubLevel created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create level');
    }

    public function updateOne(UpdateSubLevelRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.levels'), 'success', 'SubLevel updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update level');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.levels'), 'success', 'SubLevel deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete level');
    }
}
