<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Extensions\Controller\ModelGetExtension;
use App\Http\Controllers\RestApiController;
use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Requests\ExamTask\CreateExamTaskRequest;
use App\Http\Requests\ExamTask\UpdateExamTaskRequest;
use App\Models\ExamTask;
use Illuminate\Http\Request;

class ExamTaskController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse(ExamTask::with(relations: ['lecture','tasks'])->get());
    }

    public function readOne($id)
    {
        return  $this->successResponse(ExamTask::with(relations: ['lecture','tasks'])->findOrFail($id));
    }

    public function createOne(CreateExamTaskRequest $request)
    {
        if($this->create($request)) {
            return $this->successResponse(
               $this->modelCreated, 'ExamTask created successfully',201
            );
        }

        return $this->badRequestResponse( 'Failed to create ExamTask');
    }

    public function updateOne(UpdateExamTaskRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->successResponse(
               $this->modelUpdated, 'ExamTask updated successfully'
            );
        }

        return $this->badRequestResponse( 'Failed to update ExamTask');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->successResponse(
               null,  'ExamTask deleted successfully'
            );
        }

        return $this->badRequestResponse(  'Failed to delete ExamTask');
    }
}
