<?php

namespace App\Http\Controllers\RestApi\V1;

use Illuminate\Http\Request;
use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\ModelGetExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\RestApiController;
use App\Http\Requests\LectureQuestion\CreateLectureQuestionRequest;
use App\Http\Requests\LectureQuestion\UpdateLectureQuestionRequest;

class LectureQuestionController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: [
            'subLectureQuestions',
            'materials',
            'students',
        ])->get());
    }

    public function readOne($id)
    {
        return  $this->successResponse($this->model::with(relations:[
            'subLectureQuestions',
            'materials',
            'students',
        ])->findOrFail($id));
    }

    public function createOne(CreateLectureQuestionRequest $request)
    {
        if($this->create($request)) {
            return $this->successResponse(
               $this->modelCreated, 'LectureQuestion created successfully',201
            );
        }

        return $this->badRequestResponse( 'Failed to create LectureQuestion');
    }

    public function updateOne(UpdateLectureQuestionRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->successResponse(
               $this->modelUpdated, 'LectureQuestion updated successfully'
            );
        }

        return $this->badRequestResponse( 'Failed to update LectureQuestion');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->successResponse(
               null,  'LectureQuestion deleted successfully'
            );
        }

        return $this->badRequestResponse(  'Failed to delete LectureQuestion');
    }
}
