<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\ModelGetExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\RestApiController;
use App\Http\Requests\Video\CreateVideoRequest;
use App\Http\Requests\Video\UpdateVideoRequest;

class VideoController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: [
            'level',
            'materials',
            'students',
        ])->get());
    }

    public function readOne($id)
    {
        return  $this->successResponse($this->model::with(relations:[
            'level',
            'materials',
            'students',
        ])->findOrFail($id));
    }

    public function createOne(CreateVideoRequest $request)
    {
        if($this->create($request)) {
            return $this->successResponse(
               $this->modelCreated, 'Video created successfully',201
            );
        }

        return $this->badRequestResponse( 'Failed to create Video');
    }

    public function updateOne(UpdateVideoRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->successResponse(
               $this->modelUpdated, 'Video updated successfully'
            );
        }

        return $this->badRequestResponse( 'Failed to update Video');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->successResponse(
               null,  'Video deleted successfully'
            );
        }

        return $this->badRequestResponse(  'Failed to delete Video');
    }
}
