<?php

namespace App\Http\Controllers\View;

use App\Http\Controllers\Controller;
use App\Models\Legal;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Inertia\Response;

class WebController extends Controller
{

    public function home(Request $request)
    {

        return Inertia::render('Public/Home', []);
    }

    public function login(Request $request)
    {

        return Inertia::render('Public/Login', []);
    }

    public function otp(Request $request)
    {

        return Inertia::render('Public/Otp', []);
    }

    public function register(Request $request)
    {

        return Inertia::render('Public/Register', []);
    }
    public function termsAndConditions(Request $request)
    {
        return Inertia::render('Public/TermsAndConditions', [
           'terms_conditions'=> Legal::where(['type' => 'terms_conditions'])->orderBy('number')->get()
        ]);
    }
    public function privacyPolicy(Request $request)
    {
        return Inertia::render('Public/PrivacyPolicy', [
          'privacy_policy'=>  Legal::where(['type' => 'privacy_policy'])->orderBy('number')->get()
        ]);
    }
}
