<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Exam extends Model
{
    /** @use HasFactory<\Database\Factories\ExamFactory> */
    use HasFactory;

    protected $fillable = [
        'lecture_id',
    ];

    public function lecture()
    {
        return $this->belongsTo(Lecture::class);
    }
    public function tasks()
    {
        return $this->hasMany(ExamTask::class);
    }
}
