<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    /** @use HasFactory<\Database\Factories\StudentFactory> */
    use HasFactory;

    protected $fillable = [
        'birth_day',
        'user_id',
        'level_id',
        'sub_level_id',
        'country',
        'city',
        'is_active',
    ];

    protected $casts = [
        'birth_day' => 'date', // Casting the birth_day as a date
        'user_id' => 'integer',
        'level_id' => 'integer',
        'sub_level_id' => 'integer',
        'country' => 'string',
        'city' => 'string',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function level()
    {
        return $this->belongsTo(Level::class);
    }

    public function subLevel()
    {
        return $this->belongsTo(SubLevel::class);
    }

    public function studentProcess()
    {
        return $this->hasMany(StudentProcessCourse::class);
    }

    public function exams()
    {
        return $this->hasMany(StudentExams::class);
    }

    public function lectureQuestions()
    {
        return $this->hasMany(LectureQuestion::class);
    }
}
