<?php

namespace App\Services\ThirdParty;

use App\Contracts\OtpSenderInterface;
use Twilio\Rest\Client;

class TwilioService implements OtpSenderInterface
{

    protected string $to;

    public function send(int $otp): bool{
        $sid = env('TWILIO_SID');
        $token = env('TWILIO_TOKEN');
        $messagingServiceSid = env('TWILIO_MSG_SERVICE');

        try {
            $client = new Client($sid, $token);

            $message = $client->messages->create(
                $this->to,
                [
                    'body' => $otp,
                    'messagingServiceSid' => $messagingServiceSid, // Use Messaging Service SID
                ]
            );

            return true;
        } catch (\Exception $e) {
           if(app()->isLocal()) dd($e);
            return false;
        }
    }

    public function setTo(string $phone): self
    {
        $this->to = $phone;
        return $this;
    }
}
