<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('materials', function (Blueprint $table) {
            $table->id(); // id INT AUTO_INCREMENT PRIMARY KEY
            $table->string('title'); // title as VARCHAR
            $table->text('description')->nullable(); // description as TEXT, nullable
            $table->string('cover_image'); // cover_image as VARCHAR

            $table->unsignedBigInteger('level_id'); // level_id as UNSIGNED BIGINT
            $table->unsignedBigInteger('sub_level_id')->nullable(); // sub_level_id as UNSIGNED BIGINT

            $table->timestamps(); // created_at and updated_at

            // Foreign key constraints
            // $table->foreign('level_id')->references('id')->on('levels');
            // $table->foreign('sub_level_id')->references('id')->on('sub_levels');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('materials');
    }
};
