<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lectures', function (Blueprint $table) {
            $table->id(); // id INT AUTO_INCREMENT PRIMARY KEY
            $table->unsignedBigInteger('course_id'); // course_id as UNSIGNED BIGINT
            $table->unsignedBigInteger('course_section_id'); // course_section_id as UNSIGNED BIGINT
            $table->unsignedBigInteger('teacher_id'); // teacher_id as UNSIGNED BIGINT
            $table->unsignedBigInteger('video_id'); // video_id as UNSIGNED BIGINT

            $table->string('title'); // title as VARCHAR
            $table->text('description')->nullable(); // description as TEXT, nullable
            $table->string('time'); // time as VARCHAR (e.g., "2:30 PM" or "00:45:30" for duration)

            $table->integer('number'); // number as INT

            $table->boolean('is_active')->default(true); // status as BOOLEAN

            $table->timestamps(); // created_at and updated_at

            // Foreign key constraints
            // $table->foreign('course_id')->references('id')->on('courses')->onDelete('cascade');
            // $table->foreign('course_section_id')->references('id')->on('course_sections')->onDelete('cascade');
            // $table->foreign('teacher_id')->references('id')->on('teachers');
            // $table->foreign('video_id')->references('id')->on('videos')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lectures');
    }
};
