<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('student_process_courses', function (Blueprint $table) {
            $table->id(); // id INT AUTO_INCREMENT PRIMARY KEY
            $table->unsignedBigInteger('student_id'); // student_id as UNSIGNED BIG INT
            $table->unsignedBigInteger('material_id'); // material_id as UNSIGNED BIG INT
            $table->unsignedBigInteger('course_id'); // course_id as UNSIGNED BIG INT
            $table->unsignedBigInteger('teacher_id'); // teacher_id as UNSIGNED BIG INT
            $table->unsignedBigInteger('course_section_id'); // course_section_id as UNSIGNED BIG INT
            $table->unsignedBigInteger('lecture_id'); // lecture_id as UNSIGNED BIG INT

            $table->integer('last_watch_time')->default(0); // last_watch_time as INT
            $table->boolean('is_saved')->default(false); // is_saved as BOOLEAN
            $table->boolean('is_finishLecture')->default(false); // is_finishLecture as BOOLEAN
            $table->boolean('is_finishExam')->default(false); // is_finishExam as BOOLEAN
            $table->boolean('is_pass_exam')->default(false); // is_pass_exam as BOOLEAN

            $table->timestamps(); // created_at and updated_at

            // Foreign key constraints
            $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
            $table->foreign('material_id')->references('id')->on('materials')->onDelete('cascade');
            $table->foreign('course_id')->references('id')->on('courses')->onDelete('cascade');
            $table->foreign('teacher_id')->references('id')->on('teachers')->onDelete('cascade');
            $table->foreign('course_section_id')->references('id')->on('course_sections')->onDelete('cascade');
            $table->foreign('lecture_id')->references('id')->on('lectures')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('student_process_courses');
    }
};
