<?php

namespace Database\Seeders;

use App\Enums\UserTypeEnum;
use App\Models\Admin;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::create([
            'name' => 'admin',
            'first_name' => 'admin',
            'last_name' => 'admin',
            'phone' => '+12345678910',
            'email' => 'admin@admin.com',
            'password' => Hash::make('admin123456'),
            'api_token' => Str::random(20),
            'type' => UserTypeEnum::SUPER_ADMIN
        ]);
        Admin::create([
            'user_id'=>$user->id,
            'batch'=>'SuperAdmin'
        ]);
    }
}
