<?php

namespace Database\Seeders;

use App\Models\Layout;
use Illuminate\Database\Seeder;

class LayoutSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        $brand = [
            'logo'=>[
                'color'=>'/media/images/brand/color.png',
                'light'=>'/media/images/brand/light.png',
                'dark'=>'/media/images/brand/dark.png',
            ],
            'colors'=>[
                'primary'=>'#A456A6',
                'secondary'=>'#707EBD',
                'gray'=>'#111555',
                'thirdly'=>'#F29849'
            ]
        ];


        $pageData = [
            'bg' => '/media/images/bg/6099605.jpg',
            'bg_color'=>'linear-gradient(140deg, rgba(164,86,166,1) 16%, rgba(112,126,189,1) 43%, rgba(34,42,80,1) 67%)',
            'color' => '#111'
        ];

        // Fake navigation data structure
        $navData = [
            'using_in' => ['public'],
            'bg_color' => '#111',
            'menu' => [
                ['href' => '/login', 'text' => 'تسجيل الدخول'],
                ['href' => '/register', 'text' => 'حساب جديد'],
            ],
            'logo' => [
                'height' => 50, // Example height
                'width' => 150, // Example width
                'mode'=>'light'
            ]
        ];

        $navStudentData = [
            'using_in' => ['student'],
            'bg_color' => '#111222',
            'menu' => [
            ],
            'logo' => [
                'height' => 50, // Example height
                'width' => 150, // Example width
                'mode'=>'light'
            ]
        ];

        // Fake footer data
        $footerData = [
            'using_in' => ['public'],
            'bg_color' => '#111',
            'menu' => [
                ['href' => '/privacy-policy', 'text' => 'سياسة الخصوصية'],
                ['href' => '/terms-conditions', 'text' => 'الأحكام و الشروط'],
            ],
            'logo' => [
                'height' => 80, // Example height
                'width' => 150, // Example width
                'mode'=>'light',
                'display'=>false
            ],
            'apps' => [
                ['href' => '/appstore', 'text' => 'App Store', "icon" => '/media/images/icons/appstore.png'],
                ['href' => '/googleplay', 'text' => 'Google Play', "icon" => '/media/images/icons/playstore.png'],
            ],
            'socialMedia' => [
                ['href' => 'https://facebook.com', 'text' => 'فيسبوك', 'icon' => 'https://img.icons8.com/?size=100&id=118467&format=png&color=cccccc'],
                ['href' => 'https://twitter.com', 'text' => 'إكس', 'icon' => 'https://img.icons8.com/?size=100&id=phOKFKYpe00C&format=png&color=cccccc'],
                ['href' => 'https://instagram.com', 'text' => 'إنستغرام', 'icon' => 'https://img.icons8.com/?size=100&id=32309&format=png&color=cccccc'],
            ],
        ];

        $homePageData = [
            'using_in' => ['public'],
            'section_hero' => [
                'image' => '/media/images/',
                'title' => 'إرفع درجاتك و تميز مع مدرستي السورية',
                'sub_title' => 'شروحات و تدريبات و إختبارات إلكترونية',
                'button' => 'إبدأ الأن',
            ],
            'section_1' => [
                'image' => '/media/images/',
                'title' => 'شروحات فيديو',
                'sub_title' => 'فيديو لكل مدرس ، إختر المدرس المناسب لك',
            ],
            'section_2' => [
                'image' => '/media/images/',
                'title' => 'إختبارات إلكترونية',
                'sub_title' => 'ثبت معلوماتك و إستعد لإختبارات مع إختبارات إلكترونية و اعرف مستواك في كل درس',
            ],
            'section_3' => [
                'image' => '/media/images/',
                'title' => 'نوتات ذكية',
                'sub_title' => 'نوتات و تدريبات يمكنك تحميل الملف و طباعته مع ميزة الباركود توصلك للدرس و الإختبار الإلكتروني',
            ],
        ];

        Layout::truncate();

        foreach (
            [
                [
                    'field' => 'brand',
                    'config' => $brand,
                ],
                [
                    'field' => 'page_public',
                    'config' => $pageData,
                ],
                [
                    'field' => 'nav_public',
                    'config' => $navData,
                ],
                [
                    'field' => 'nav_student',
                    'config' => $navStudentData,
                ],
                [
                    'field' => 'footer_public',
                    'config' => $footerData,
                ],
                [
                    'field' => 'home_page',
                    'config' => $homePageData,
                ],


            ] as  $item
        ) {
            Layout::create($item);
        }
    }
}
