"use strict";Object.defineProperty(exports,"__esModule",{value:true});function _export(target,all){for(var name in all)Object.defineProperty(target,name,{enumerable:true,get:all[name]})}_export(exports,{Button:function(){return Button},default:function(){return _default}});var _react=_interopRequireDefault(require("react"));var _propTypes=_interopRequireDefault(require("prop-types"));var _materialRippleEffects=_interopRequireDefault(require("material-ripple-effects"));var _classnames=_interopRequireDefault(require("classnames"));var _tailwindMerge=require("tailwind-merge");var _findMatch=_interopRequireDefault(require("../../utils/findMatch"));var _objectsToString=_interopRequireDefault(require("../../utils/objectsToString"));var _theme=require("../../context/theme");var _spinner=_interopRequireDefault(require("../Spinner"));var _button=require("../../types/components/button");function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _objectWithoutProperties(source,excluded){if(source==null)return{};var target=_objectWithoutPropertiesLoose(source,excluded);var key,i;if(Object.getOwnPropertySymbols){var sourceSymbolKeys=Object.getOwnPropertySymbols(source);for(i=0;i<sourceSymbolKeys.length;i++){key=sourceSymbolKeys[i];if(excluded.indexOf(key)>=0)continue;if(!Object.prototype.propertyIsEnumerable.call(source,key))continue;target[key]=source[key]}}return target}function _objectWithoutPropertiesLoose(source,excluded){if(source==null)return{};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key]}return target}var Button=_react.default.forwardRef(function(_param,ref){var variant=_param.variant,size=_param.size,color=_param.color,fullWidth=_param.fullWidth,ripple=_param.ripple,className=_param.className,children=_param.children,loading=_param.loading,rest=_objectWithoutProperties(_param,["variant","size","color","fullWidth","ripple","className","children","loading"]);var button=(0,_theme.useTheme)().button;var valid=button.valid,defaultProps=button.defaultProps,styles=button.styles;var base=styles.base,variants=styles.variants,sizes=styles.sizes;variant=variant!==null&&variant!==void 0?variant:defaultProps.variant;size=size!==null&&size!==void 0?size:defaultProps.size;color=color!==null&&color!==void 0?color:defaultProps.color;fullWidth=fullWidth!==null&&fullWidth!==void 0?fullWidth:defaultProps.fullWidth;ripple=ripple!==null&&ripple!==void 0?ripple:defaultProps.ripple;className=(0,_tailwindMerge.twMerge)(defaultProps.className||"",className);var rippleEffect=ripple!==undefined&&new _materialRippleEffects.default;var buttonBase=(0,_objectsToString.default)(base.initial);var buttonVariant=(0,_objectsToString.default)(variants[(0,_findMatch.default)(valid.variants,variant,"filled")][(0,_findMatch.default)(valid.colors,color,"gray")]);var buttonSize=(0,_objectsToString.default)(sizes[(0,_findMatch.default)(valid.sizes,size,"md")]);var classes=(0,_tailwindMerge.twMerge)((0,_classnames.default)(buttonBase,buttonSize,buttonVariant,_defineProperty({},(0,_objectsToString.default)(base.fullWidth),fullWidth),{"flex items-center gap-2":loading,"gap-3":size==="lg"}),className);var spinnerClass=(0,_tailwindMerge.twMerge)((0,_classnames.default)({"w-4 h-4":true,"w-5 h-5":size==="lg"}));var _rest_disabled;return _react.default.createElement("button",_extends({},rest,{disabled:(_rest_disabled=rest.disabled)!==null&&_rest_disabled!==void 0?_rest_disabled:loading,ref:ref,className:classes,type:rest.type||"button",onMouseDown:function(e){var onMouseDown=rest===null||rest===void 0?void 0:rest.onMouseDown;if(ripple){rippleEffect.create(e,(variant==="filled"||variant==="gradient")&&color!=="white"?"light":"dark")}return typeof onMouseDown==="function"&&onMouseDown(e)}}),loading&&_react.default.createElement(_spinner.default,{className:spinnerClass}),children)});Button.propTypes={variant:_propTypes.default.oneOf(_button.propTypesVariant),size:_propTypes.default.oneOf(_button.propTypesSize),color:_propTypes.default.oneOf(_button.propTypesColor),fullWidth:_button.propTypesFullWidth,ripple:_button.propTypesRipple,className:_button.propTypesClassName,children:_button.propTypesChildren,loading:_button.propTypesLoading};Button.displayName="MaterialTailwind.Button";var _default=Button;