import type { ElementProps, FloatingContext, ReferenceType } from '../types';
export interface Props {
    enabled?: boolean;
    event?: 'click' | 'mousedown';
    toggle?: boolean;
    ignoreMouse?: boolean;
    keyboardHandlers?: boolean;
}
/**
 * Adds click event listeners that change the open state.
 * @see https://floating-ui.com/docs/useClick
 */
export declare const useClick: <RT extends ReferenceType = ReferenceType>({ open, onOpenChange, dataRef, elements: { domReference } }: FloatingContext<RT>, { enabled, event: eventOption, toggle, ignoreMouse, keyboardHandlers, }?: Props) => ElementProps;
