import React, { useState } from 'react';

const VideoPlayer: React.FC = () => {
  const [currentTime, setCurrentTime] = useState(0);

  const handleTimeUpdate = (event: React.SyntheticEvent<HTMLVideoElement>) => {
    const video = event.target as HTMLVideoElement;
    setCurrentTime(video.currentTime); // Update the current time
  };

  return (
    <div>
      <video
        width="600"
        controls
        onTimeUpdate={handleTimeUpdate}
        src="your-video-url.mp4"
      >
        Your browser does not support the video tag.
      </video>
      <div>Time Played: {currentTime.toFixed(2)} seconds</div>
    </div>
  );
};

export default VideoPlayer;
