import { InputHTMLAttributes } from 'react'
import FormElement from './FormElement'
import Checkbox from './Checkbox'

type Props = InputHTMLAttributes<HTMLInputElement> & {
    label?: string
    error?: string
    labelClassName?: string
}

const FormCheckbox = ({ label, labelClassName, error, ...props }: Props) => {
    return (
        <FormElement className="flex gap-3  items-center mt-3 " error={error} label={label} labelClassName={labelClassName}>
            <Checkbox id={label} {...props} />
        </FormElement>
    )
}

export default FormCheckbox
