import { PageHead } from '@/Components'
import { DashboardNav, DashboardSideBar } from '@/Ui'
import { Head } from '@inertiajs/react'
import { PropsWithChildren, ReactNode } from 'react'

type Props = {
    title: string
    headChild?: ReactNode
}

const DashboardLayout = ({ title, children, headChild }: PropsWithChildren<Props>) => {
    return (
        <div>
            <Head title={title} />
            <DashboardSideBar />
            <div >
                <SidebarButton />
                <DashboardSideBar />
                <div className=" sm:mr-64 ">
                    <DashboardNav />
                    <div className="p-4">
                        <div className="p-4 bg-gray-50 border min-h-screen rounded-lg ">
                            <header className="flex border-b items-center pb-3 justify-between mb-10  ">
                                <PageHead>{title} </PageHead>
                                {headChild}
                            </header>
                            <div className="pb-10">
                                {children}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default DashboardLayout


const SidebarButton = () => {
    return (
        <button
            data-drawer-target="default-sidebar"
            data-drawer-toggle="default-sidebar"
            aria-controls="default-sidebar"
            type="button"
            className="inline-flex items-center p-2 mt-2 ms-3 text-sm text-gray-500 rounded-lg sm:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-gray-700 dark:focus:ring-gray-600"
        >
            <span className="sr-only">Open sidebar</span>
            <svg
                className="w-6 h-6"
                aria-hidden="true"
                fill="currentColor"
                viewBox="0 0 20 20"
                xmlns="http://www.w3.org/2000/svg"
            >
                <path
                    clipRule="evenodd"
                    fillRule="evenodd"
                    d="M2 4.75A.75.75 0 012.75 4h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 4.75zm0 10.5a.75.75 0 01.75-.75h7.5a.75.75 0 010 1.5h-7.5a.75.75 0 01-.75-.75zM2 10a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 10z"
                />
            </svg>
        </button>
    )
}
