import DashboardLayout from '@/Layouts/DashboardLayout'
import React from 'react'
import { Space, Table, Tag } from 'antd';
import type { TableProps } from 'antd';
import { User } from '@/types';
import moment from 'moment';
import { ButtonCreate, ButtonDelete, ButtonEdit } from '@/Ui';


type Props = {
    users: User[]
}

const columns: TableProps<User>['columns'] = [
    {
        title: 'إسم المستخدم',
        dataIndex: 'name',
        key: 'name',
        render: (text) => <a>{text}</a>,
    },
    {
        title: 'الإسم',
        dataIndex: 'first_name',
        key: 'first_name',
        render: (text) => <a>{text}</a>,
    },
    {
        title: 'اللقب',
        dataIndex: 'last_name',
        key: 'last_name',
        render: (text) => <a>{text}</a>,
    },
    {
        title: 'رقم الهاتف',
        dataIndex: 'phone',
        key: 'phone',
        render: (text) => <a>{text}</a>,
    },
    {
        title: 'البريد الإلكتروني',
        dataIndex: 'email',
        key: 'email',
        render: (text) => <a>{text}</a>,
    },
    {
        title: 'تاريخ الإنشاء',
        dataIndex: 'created_at',
        key: 'created_at',
        render: (text) => <a>{moment(text).format('YYYY-MM-DD')}</a>,
    },
    {
        title: '',
        dataIndex: 'd',
        key: 'd',
        render: () => <div className="flex justify-end gap-2">

            <ButtonEdit />
            <ButtonDelete />
        </div>,
    },
]


const Users = ({ users }: Props) => {
    return (
        <DashboardLayout title='المستخدمون' headChild={ <ButtonCreate />}>
            <Table<User> bordered columns={columns} dataSource={users} />
        </DashboardLayout>
    )
}

export default Users
