import { FormInput, PrimaryButton } from '@/Components'
import PublicLayout from '@/Layouts/PublicLayout'
import { useForm } from '@inertiajs/react'
import { FormEventHandler } from 'react'

type Props = {}

const Register = (props: Props) => {

    const {data,setData,errors,post}=useForm({
        phone: "",
        name:''
    })

    const submit : FormEventHandler = e=>{
        e.preventDefault()
        post(route('auth.student.register'));
    }

    return (
        <PublicLayout title='إنشاء حساب جديد' withNav={false} >
            <div className="mx-auto flex justify-center mt-20">
                <form onSubmit={submit} className="bg-[#111] rounded-md w-1/3 text-pink-50 p-8 flex flex-col gap-5">
                    <h1 className='text-center text-3xl mb-5 text-pink-50' >إنشاء حساب جديد</h1>
                    <FormInput dir='ltr' value={data.name} onChange={e=>setData('name',e.target.value)} error={errors.name} label='إسم المستخدم' name='name' placeholder='' className='w-full bg-transparent text-white' />
                    <FormInput dir='ltr' value={data.phone} onChange={e=>setData('phone',e.target.value)} error={errors.phone} label='أدخل رقم الهاتف' name='phone' placeholder='رقم الهاتف' className='w-full bg-transparent text-white' />
                    <PrimaryButton className='w-full' >تسجيل</PrimaryButton>
                </form>
            </div>
        </PublicLayout>
    )
}

export default Register
