import PublicLayout from '@/Layouts/PublicLayout'
import { PageProps } from '@/types'
import { Legal } from '@/types/models/legal'
import React from 'react'

type Props = {}

const TermsAndConditions = ({ terms_conditions }: PageProps<{ terms_conditions: Legal[] }>) => {

    return (
        <PublicLayout title='الأحكام و الشروط'>
            <h1 className="mb-20 mt-10 text-4xl text-white text-center font-bold ">الأحكام و الشروط</h1>
            {terms_conditions.map((item,i) => (
                <div className="text-white mb-10 flex flex-col gap-10" key={i}>
                    <strong className='text-3xl font-semibold ' >{item.title} </strong>
                    <p className='mb-10' >{item.content} </p>
                </div>
            ))}
        </PublicLayout>
    )
}

export default TermsAndConditions
