import { FormCheckbox, FormElement, FormInput, PrimaryButton } from '@/Components'
import { useFormProps } from '@/types/app'
import { Lecture } from '@/types/models/lecture'
import { Teacher } from '@/types/models/teacher'
import { Video } from '@/types/models/video'
import { Divider, Select } from 'antd'
import { FormEventHandler } from 'react'

type Props = {
    submit: FormEventHandler<HTMLFormElement>
    form: useFormProps<Lecture>
    teachers: Teacher[]
    videos: Video[]
}

const LectureForm = ({ form, submit, teachers, videos }: Props) => {
    return (
        <form className='flex flex-col gap-3' onSubmit={submit}>
            <Divider orientation="left" >معلومات المنهج</Divider>
            <FormInput label='العنوان' name='title' value={form.data.title} onChange={e => form.setData('title', e.target.value)} error={form.errors.title} />
            <FormInput label='الوصف' name='description' value={form.data.description} onChange={e => form.setData('description', e.target.value)} error={form.errors.description} />
            <FormInput label='رقم المنهج' name='number' value={form.data.number} onChange={e => form.setData('number', e.target.value)} error={form.errors.description} />
            <FormCheckbox label='نشط' name='is_active' checked={form.data.is_active} onChange={e => form.setData('is_active', e.target.checked)} error={form.errors.is_active} />

            <FormElement label='المعلم'  error={form.errors.teacher_id}>
                <Select className='w-full' onSelect={s => form.setData('teacher_id', s)} value={form.data.teacher_id}>
                    {teachers.map(m => <Select.Option value={m.id} key={m.id} > {`${m.user.first_name} ${m.user.last_name}`} </Select.Option>)}
                </Select>
            </FormElement>

            <FormElement label='الفيديو'  error={form.errors.video_id} >
                <Select className='w-full' onSelect={s => form.setData('video_id', s)} value={form.data.video_id}>
                    {videos.map(m => <Select.Option value={m.id} key={m.id} > {m.file.split('/').pop() ?? ''} </Select.Option>)}
                </Select>
            </FormElement>

            <PrimaryButton className='mt-5' >حفظ</PrimaryButton>
        </form>
    )
}

export default LectureForm
