import { FormInput, FormTextarea, PrimaryButton } from '@/Components'
import { useFormProps } from '@/types/app'
import { Level } from '@/types/models/level'
import { Divider } from 'antd'
import React, { FormEventHandler } from 'react'

type Props = {
    submit: FormEventHandler<HTMLFormElement>
    form: useFormProps<Level>
}

const LevelForm = ({ form, submit }: Props) => {
    return (
        <form className='flex flex-col gap-3' onSubmit={submit}>
            <Divider orientation="left" >معلومات الصف</Divider>
            <FormInput label='العنوان' name='title' value={form.data.title} onChange={e => form.setData('title', e.target.value)} error={form.errors.title} />
            <FormTextarea label='الوصف' name='description' value={form.data.description} onChange={e => form.setData('description', e.target.value)} error={form.errors.description} />

            <PrimaryButton className='mt-5' >حفظ</PrimaryButton>
        </form>
    )
}

export default LevelForm
