import { FormInput, PrimaryButton } from '@/Components'
import { useFormProps } from '@/types/app'
import { Level } from '@/types/models/level'
import { Divider } from 'antd'
import React, { FormEventHandler } from 'react'
import LevelSelect from './LevelSelect'
import { SubLevel } from '@/types/models/sub_level'

type Props = {
    submit: FormEventHandler<HTMLFormElement>
    form: useFormProps<SubLevel>
    levels:Level[]
}

const LevelForm = ({ form, submit ,levels}: Props) => {
    return (
        <form className='flex flex-col gap-3' onSubmit={submit}>
            <Divider orientation="left" >معلومات الصف</Divider>
            <FormInput label='العنوان' name='title' value={form.data.title} onChange={e => form.setData('title', e.target.value)} error={form.errors.title} />
            <FormInput label='الوصف' name='description' value={form.data.description} onChange={e => form.setData('description', e.target.value)} error={form.errors.description} />
            <LevelSelect selected={form.data.level_id} levels={levels} onSelect={level=>form.setData('level_id',level)} />
            <PrimaryButton className='mt-5' >حفظ</PrimaryButton>
        </form>
    )
}

export default LevelForm
