import React, { useState } from 'react';
import { Exam } from '@/types/models/exam';

type Props = {
    exam?: Exam;
};

const ExamDisplay = ({ exam }: Props) => {
    const [currentQuestionIndex, setCurrentQuestionIndex] = useState(0);
    const [answers, setAnswers] = useState<Record<number, string>>({});
    const [isSubmitted, setIsSubmitted] = useState(false);


    if (!exam || !exam.tasks.map(m => m.question) || exam.tasks.length === 0) {
        return <h1>No Exam</h1>;
    }
    const questions = exam.tasks.map(m => m.question)

    const currentQuestion = questions[currentQuestionIndex];

    const handleChoiceClick = (choice: string) => {
        setAnswers((prev) => ({ ...prev, [currentQuestionIndex]: choice }));
    };

    const handleNext = () => {
        if (currentQuestionIndex < questions.length - 1) {
            setCurrentQuestionIndex((prev) => prev + 1);
        }
    };

    const handlePrevious = () => {
        if (currentQuestionIndex > 0) {
            setCurrentQuestionIndex((prev) => prev - 1);
        }
    };

    const handleSubmit = () => {
        setIsSubmitted(true);
    };

    if (isSubmitted) {
        return (
            <div className='bg-black p-8 text-white rounded-md'>
                <h1 className='mb-10 text-2xl text-orange-700 font-semibold'>نتائج الإمتحان</h1>
                {questions.map((question, index) => (
                    <div key={index} className="mb-4  ">
                        <h2 className=''>
                            {index + 1}. {question}
                        </h2>
                        <p className='flex gap-2'>
                            <strong>إجابتك:</strong>
                            <span className={exam.tasks.find(m => m.question === question)?.answer === answers[index] ? 'text-green-700' : 'text-red-500'} >{answers[index] || 'لا إجابة'} </span>

                        </p>
                        {/* <p>
                            <strong>الإجابة الصحيحية:</strong> {exam.tasks.find(m => m.question === question)?.answer}
                        </p> */}
                    </div>
                ))}
            </div>
        );
    }

    console.log(exam.tasks.find(m => m.question === currentQuestion))

    return (
        <div className='bg-black p-8 text-white rounded-md'>
            <div className="mb-4  mx-5">
                <h2 className='font-semibold mb-10 '>
                    {currentQuestionIndex + 1}. {currentQuestion}
                </h2>
                <div className="mt-2">
                    {exam.tasks.find(m => m.question === currentQuestion)?.choices.map((choice, index) => (
                        <div
                            key={index}
                            onClick={() => handleChoiceClick(choice)}
                            className={`w-full mb-3 p-4 cursor-pointer hover:opacity-80 rounded-md ${answers[currentQuestionIndex] === choice
                                ? 'bg-blue-500 text-white'
                                : 'bg-gray-900'
                                }`}
                        >
                            {choice}
                        </div>
                    ))}
                </div>
            </div>
            <div className="flex justify-between mt-10  mx-5">
                <button
                    onClick={handlePrevious}
                    disabled={currentQuestionIndex === 0}
                    className="bg-gray-500 text-white px-8 py-2 rounded-3xl disabled:opacity-50"
                >
                    السابق
                </button>
                {currentQuestionIndex === questions.length - 1 ? (
                    <button
                        onClick={handleSubmit}
                        className="bg-green-500 text-white px-8 py-2 rounded-3xl"
                    >
                        إرسال
                    </button>
                ) : (
                    <button
                        onClick={handleNext}
                        disabled={currentQuestionIndex === questions.length - 1}
                        className="bg-blue-500 text-white px-8 py-2 rounded-3xl"
                    >
                        التالي
                    </button>
                )}
            </div>
        </div>
    );
};

export default ExamDisplay;
