import { StatusEnum } from '@/Enums/StatusEnum';
import { Course } from './course';
import { ID, Model } from './index';
import { Level } from './level';
import { SubLevel } from './sub_level';

export type Material = Model & {
    title: string;
    description?: string; // Nullable
    cover_image: string;
    level_id: ID;
    sub_level_id?: ID|null;

    courses: Course[]
    level:Level
    sub_level?:SubLevel|null
    notes?:MaterialNote
  };

  export type MaterialNote = Model & {

    material_id:ID
    title:string
    description?:string
    type:string
    icon:string
    file?:string
    status:StatusEnum

    material?:Material
  }
