<?php

use App\Http\Controllers\Core\CourseController;
use App\Http\Controllers\Core\CourseNoteController;
use App\Http\Controllers\Core\CourseSectionController;
use App\Http\Controllers\Core\ExamController;
use App\Http\Controllers\Core\ExamTaskController;
use App\Http\Controllers\Core\LayoutController;
use App\Http\Controllers\Core\LectureController;
use App\Http\Controllers\Core\LevelController;
use App\Http\Controllers\Core\MaterialController;
use App\Http\Controllers\Core\PermissionController;
use App\Http\Controllers\Core\RoleController;
use App\Http\Controllers\Core\StudentProcessCourseController;
use App\Http\Controllers\Core\SubLevelController;
use App\Http\Controllers\Core\TeacherController;
use App\Http\Controllers\Core\VideoController;
use App\Http\Controllers\View\DashboardController;
use App\Http\Middleware\RestApi\DashboardMiddleware;
use App\Http\Middleware\View\AdminMiddleware;
use Illuminate\Support\Facades\Route;

Route::controller(DashboardController::class)
    ->middleware(['auth', DashboardMiddleware::class])
    ->prefix('admin')
    ->group(function () {

        Route::get('/', 'dashboard')->name('admin.dashboard');
        Route::get('/settings', 'settings')->name('admin.settings');
        Route::get('/layout', 'layout')->name('admin.layout');
        Route::get('/materials', 'materials')->name('admin.materials');
        Route::get('/material/{id}', 'materialDetails')->name('admin.materials.detail');
        Route::get('/exams', 'exams')->name('admin.exams');
        Route::get('/exam/{id}', 'examDetail')->name('admin.exams.detail');
        Route::get('/exam/create/new', 'examDetail')->name('admin.exams.new');
        Route::get('/notes', 'notes')->name('admin.notes');
        Route::get('/note/{id}', 'noteDetail')->name('admin.notes.detail');
        Route::get('/users', 'users')->name('admin.users');
        Route::get('/students', 'students')->name('admin.students');
        Route::get('/student/{id}', 'studentDetail')->name('admin.studentDetail');
        Route::get('/teachers', 'teachers')->name('admin.teachers');
        Route::get('/teacher/{id}', 'teacherDetail')->name('admin.teacherDetail');
        Route::get('/admins', 'admins')->name('admin.admins');
        Route::get('/admin/{id}', 'adminDetail')->name('admin.adminDetail');
        Route::get('/levels', 'levels')->name('admin.levels');
        Route::get('/videos', 'videos')->name('admin.videos');
        Route::get('/roles', 'roles')->name('admin.roles');
        Route::get('/permissions', 'permissions')->name('admin.permissions');


        Route::prefix('layout')->controller(LayoutController::class)
            ->group(function () {
                Route::put('/update/{id}', 'updateOne')->name('admin.layout.updateOne');
            });

        Route::prefix('material')->controller(MaterialController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.material.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.material.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.material.deleteOne');
            });

        Route::prefix('exam')->controller(ExamController::class)
            ->group(function () {
                Route::post('/create', 'create')->name('admin.exam.createOne');
                Route::put('/update/{id}', 'update')->name('admin.exam.updateOne');
                Route::delete('/delete/{id}', 'delete')->name('admin.exam.deleteOne');
            });

        Route::prefix('exam-task')->controller(ExamTaskController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.examTask.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.examTask.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.examTask.deleteOne');
            });

        Route::prefix('level')->controller(LevelController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.level.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.level.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.level.deleteOne');
            });

        Route::prefix('sub-level')->controller(SubLevelController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.subLevel.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.subLevel.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.subLevel.deleteOne');
            });

        Route::prefix('course')->controller(CourseController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.course.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.course.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.course.deleteOne');
            });

        Route::prefix('course-section')->controller(CourseSectionController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.courseSection.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.courseSection.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.courseSection.deleteOne');
            });

        Route::prefix('course-note')->controller(CourseNoteController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.courseNote.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.courseNote.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.courseNote.deleteOne');
            });

        Route::prefix('lecture')->controller(LectureController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.lecture.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.lecture.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.lecture.deleteOne');
            });

        Route::prefix('teacher')->controller(TeacherController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.teacher.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.teacher.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.teacher.deleteOne');
            });

        Route::prefix('role')->controller(RoleController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.role.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.role.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.role.deleteOne');
            });

        Route::prefix('permission')->controller(PermissionController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.permission.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.permission.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.permission.deleteOne');
            });

        Route::prefix('video')->controller(VideoController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.video.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.video.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.video.deleteOne');
            });

        Route::prefix('student-process-courses')->controller(StudentProcessCourseController::class)
            ->group(function () {
                Route::post('/create', 'createOne')->name('admin.studentProcessCourses.createOne');
                Route::put('/update/{id}', 'updateOne')->name('admin.studentProcessCourses.updateOne');
                Route::delete('/delete/{id}', 'deleteOne')->name('admin.studentProcessCourses.deleteOne');
            });
    });
