<?php

use App\Http\Controllers\View\StudentController;
use App\Http\Middleware\View\StudentMiddleware;
use Illuminate\Support\Facades\Route;

Route::controller(StudentController::class)
    ->middleware(['auth',StudentMiddleware::class])
    ->prefix('student')
    ->group(function () {

        Route::get('/', 'home')->name('student.home');
        Route::get('/profile', 'profile')->name('student.profile');
        Route::get('/material/{id}', 'material')->name('student.material');
        Route::get('/note/{id}', 'note')->name('student.note');
        Route::get('/material-notes/{materialId}', 'materialNotes')->name('student.materialNotes');
        Route::get('/material-notes/detail/{id}', 'materialNotesDetail')->name('student.materialNotes.detail');
        Route::get('/course-lectures/{id}/{videoId}', 'courseLectures')->name('student.courseLectures');
        Route::get('/exams/{id}', 'allExams')->name('student.allExams');
        Route::get('/exam/{id}', 'exam')->name('student.exam');

    });
